#region References

using System;
using System.Collections;
using System.Data;
using System.Text;

using gov.va.med.vbecs.Common;

using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

#endregion

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>7/12/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Patient change business object layer class.
	///</summary>

	#endregion

	public class PatientChange : BaseBusinessObject 
	{
		#region Variables

		private DataRow _drCurrent;

		/// <summary>
		/// CR 3164
		/// </summary>
		private static string _divisionDelimiter;
		private static char [] _divisionDelimiterSplitter;

		#endregion

		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3909"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3203"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientDisplayVistaPatientId
		/// </summary>
		public string FromPatientDisplayVistaPatientId
		{
			get
			{
				if (this._drCurrent.IsNull(ARTIFICIAL.FromDisplayVistaPatientId))
					return string.Empty;

				return this._drCurrent[ARTIFICIAL.FromDisplayVistaPatientId].ToString();
			}
			set
			{
				this._drCurrent[ARTIFICIAL.FromDisplayVistaPatientId] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/7/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8367"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8368"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// FromPatientSsn
		/// </summary>
		public string FromPatientSsn
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientSsn))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientSsn].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientSsn] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3910"> 
		///		<ExpectedInput>guid</ExpectedInput>
		///		<ExpectedOutput>guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3911"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientGuid
		/// </summary>
		public Guid FromPatientGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientChange.FromPatientGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3206"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3912"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientIcn
		/// </summary>
		public string FromPatientIcn
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientIcn))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientIcn].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientIcn] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3915"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3916"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientLastName
		/// </summary>
		public string FromPatientLastName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientLastName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientLastName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientLastName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3920"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3211"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientFirstName
		/// </summary>
		public string FromPatientFirstName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientFirstName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientFirstName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientFirstName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3212"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3213"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientMiddleName
		/// </summary>
		public string FromPatientMiddleName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientMIddleName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientMIddleName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientMIddleName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3214"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3215"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientDob
		/// </summary>
		public DateTime FromPatientDob
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientDob))
					return DateTime.MinValue;

				return (DateTime)this._drCurrent[TABLE.PatientChange.FromPatientDob];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientDob] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3216"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3217"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientDeathDate
		/// </summary>
		public DateTime FromPatientDeathDate
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientDeathDate))
					return DateTime.MinValue;

				return (DateTime)this._drCurrent[TABLE.PatientChange.FromPatientDeathDate];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientDeathDate] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3220"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3221"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FromPatientSexCode
		/// </summary>
		public string FromPatientSexCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromPatientSexCode))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.FromPatientSexCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromPatientSexCode] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8361"> 
		///		<ExpectedInput>boolean</ExpectedInput>
		///		<ExpectedOutput>boolean</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8362"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// FromSsnPseudoIndicator
		/// </summary>
		public bool FromSsnPseudoIndicator
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.FromSsnPseudoIndicator))
					return false;

				return Convert.ToBoolean(this._drCurrent[TABLE.PatientChange.FromSsnPseudoIndicator]);
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.FromSsnPseudoIndicator] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3222"> 
		///		<ExpectedInput>decimal</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3223"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// MergeFromVistaPatientId
		/// CR 2431	changed to long to allow for the database change of the MergeFromVistaPatientId to Bigint
		/// </summary>
		public long MergeFromVistaPatientId
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.MergeFromVistaPatientId))
					return 0;

				return (long)this._drCurrent[TABLE.PatientChange.MergeFromVistaPatientId];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.MergeFromVistaPatientId] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3224"> 
		///		<ExpectedInput>decimal</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3225"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// MergeToVistaPatientId
		/// CR 2431	changed to long to allow for the database change of the MergeToVistaPatientId to Bigint
		/// </summary>
		public long MergeToVistaPatientId
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.MergeToVistaPatientId))
					return 0;

				return (long)this._drCurrent[TABLE.PatientChange.MergeToVistaPatientId];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.MergeToVistaPatientId] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3226"> 
		///		<ExpectedInput>Common.PatientChangeStatus</ExpectedInput>
		///		<ExpectedOutput>Common.PatientChangeStatus</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3228"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientChangeStatusCode
		/// </summary>
		public Common.PatientChangeStatus PatientChangeStatusCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.PatientChangeStatusCode))
					return Common.PatientChangeStatus.Unknown;

				return Common.Utility.GetPatientChangeStatusCodeFromString(this._drCurrent[TABLE.PatientChange.PatientChangeStatusCode].ToString());
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.PatientChangeStatusCode] = Common.Utility.GetPatientChangeStatusCodeFromEnum(value);
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3229"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3230"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientChangeGuid
		/// </summary>
		public Guid PatientChangeGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.PatientChangeGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientChange.PatientChangeGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.PatientChangeGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3234"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3236"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientDisplayVistaPatientId
		/// </summary>
		public string ToPatientDisplayVistaPatientId
		{
			get
			{
				if (this._drCurrent.IsNull(ARTIFICIAL.ToDisplayVistaPatientId))
					return string.Empty;

				return this._drCurrent[ARTIFICIAL.ToDisplayVistaPatientId].ToString();
			}
			set
			{
				this._drCurrent[ARTIFICIAL.ToDisplayVistaPatientId] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3238"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3240"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientGuid
		/// </summary>
		public Guid ToPatientGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientChange.ToPatientGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3242"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3244"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientSsn
		/// </summary>
		public string ToPatientSsn
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientSsn))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientSsn].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientSsn] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3246"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3248"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientIcn
		/// </summary>
		public string ToPatientIcn
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientIcn))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientIcn].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientIcn] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3250"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3252"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientLastName
		/// </summary>
		public string ToPatientLastName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientLastName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientLastName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientLastName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3254"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3256"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientFirstName
		/// </summary>
		public string ToPatientFirstName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientFirstName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientFirstName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientFirstName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3258"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3265"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientMiddleName
		/// </summary>
		public string ToPatientMiddleName
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientMIddleName))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientMIddleName].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientMIddleName] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3266"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3267"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientDob
		/// </summary>
		public DateTime ToPatientDob
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientDob))
					return DateTime.MinValue;

				return (DateTime)this._drCurrent[TABLE.PatientChange.ToPatientDob];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientDob] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3269"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3281"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientDeathDate
		/// </summary>
		public DateTime ToPatientDeathDate
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientDeathDate))
					return DateTime.MinValue;

				return (DateTime)this._drCurrent[TABLE.PatientChange.ToPatientDeathDate];
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientDeathDate] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3286"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3287"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToPatientSexCode
		/// </summary>
		public string ToPatientSexCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToPatientSexCode))
					return string.Empty;

				return this._drCurrent[TABLE.PatientChange.ToPatientSexCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToPatientSexCode] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8363"> 
		///		<ExpectedInput>boolean</ExpectedInput>
		///		<ExpectedOutput>boolean</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8364"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ToSsnPseudoIndicator
		/// </summary>
		public bool ToSsnPseudoIndicator
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ToSsnPseudoIndicator))
					return false;

				return Convert.ToBoolean(this._drCurrent[TABLE.PatientChange.ToSsnPseudoIndicator]);
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ToSsnPseudoIndicator] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>VHA</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2009</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8945"> 
		///		<ExpectedInput>Valid Date</ExpectedInput>
		///		<ExpectedOutput>Valid Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8946"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 2675
		/// </summary>
		public DateTime NotificationReceivedDate
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.NotificationReceivedDate))
					return DateTime.MinValue;

				return (DateTime)(this._drCurrent[TABLE.PatientChange.NotificationReceivedDate]);
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.NotificationReceivedDate] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/2/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9221"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9222"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164
		/// </summary>
		public string ActiveDivisionsAlertViewed
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientChange.ActiveDivisionsAlertViewed))
					return string.Empty;

				return (this._drCurrent[TABLE.PatientChange.ActiveDivisionsAlertViewed]).ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientChange.ActiveDivisionsAlertViewed] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9229"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9230"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164
		/// </summary>
		public string DivisionsWithActiveOrders
		{
			get
			{
				if (this._drCurrent.IsNull(ARTIFICIAL.DivisionsWithActiveOrders))
					return string.Empty;

				return (this._drCurrent[ARTIFICIAL.DivisionsWithActiveOrders]).ToString();
			}
			set
			{
				this._drCurrent[ARTIFICIAL.DivisionsWithActiveOrders] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Department of Veterans Affairs</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/3/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9223"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9224"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164
		/// </summary>
		public static string DivisionDelimiter
		{
			get
			{
				return _divisionDelimiter;
			}
		}

		///<Developers>
		///	<Developer>Department of Veterans Affairs</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/3/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9225"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9226"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164
		/// </summary>
		public static char [] DivisionDelimiterSplitter
		{
			get
			{
				return _divisionDelimiterSplitter;
			}
		}

		#endregion

		#region Methods

		#region Constructors

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9231"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9232"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164
		/// </summary>
		static PatientChange()
		{
			_divisionDelimiter = "^";
			_divisionDelimiterSplitter = new char[]{ '^' };
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3288"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>PatientChange objet</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3289"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor : Default
		/// </summary>
		public PatientChange()
		{
			DataTable patientChangeTable = GetEmptyPatientChangeTable();

			this._drCurrent = patientChangeTable.NewRow();
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3290"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>PatientChange objet</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3296"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor : DataRow parameter
		/// </summary>
		public PatientChange(DataRow patientChangeRow)
		{
			DataTable patientChangeTable = GetEmptyPatientChangeTable();

			this._drCurrent = patientChangeTable.NewRow();
			
			this.LoadFromDataRow(patientChangeRow);
		}

		#endregion

		#region Instance Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/02/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4947"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4948"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Updates the Patient Change Status field for this Patient
		/// </summary>
		/// <returns>Success Indicator</returns>
		public bool UpdatePatientChangeStatus()
		{
            bool result = true;

            try
            {
                // CR 3164: added ActiveDivisionsAlertViewed
                result = DAL.Patient.UpdatePatientChangeStatus(
                    this.PatientChangeGuid, this.PatientChangeStatusCode, this.ActiveDivisionsAlertViewed, this.RowVersion, Common.UpdateFunction.UC068_FrmMergePatients);
            }
            catch (Common.DataAccessLayerException)
            {
                // Suppress row-version exception; although unlikely, this could happen if two users have  
                // this window open at the same time, and they both try to clear the alert; only one user 
                // will have the correct row version
            }
            return result;
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9233"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9234"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164: validates that all updates have been viewed
		/// </summary>
		/// <param name="activeDivisionsForAlertList"></param>
		/// <param name="divisionsWithActiveOrdersList"></param>
		/// <returns></returns>
		public bool AllUpdatesViewed( ArrayList activeDivisionsForAlertList, ArrayList divisionsWithActiveOrdersList )
		{
			if ( divisionsWithActiveOrdersList != null )
			{
				for (int idx = 0; idx < divisionsWithActiveOrdersList.Count; idx++)
				{
					if ( activeDivisionsForAlertList == null || !activeDivisionsForAlertList.Contains(divisionsWithActiveOrdersList[idx]) )
					{	
						return false;
					}
				}
			}
			//
			return true;
		}

		#endregion

		#region Load Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		/// <summary>
		/// Creates a DataTable of the PatientTransfusionReaction table
		/// </summary>
		/// <returns>Empty DataTable</returns>
		private DataTable GetEmptyPatientChangeTable()
		{
			System.Data.DataTable dt = new System.Data.DataTable(TABLE.PatientChange.TableName);

			dt.Columns.Add(TABLE.PatientChange.PatientChangeGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientChange.FromPatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientChange.FromPatientSsn, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromPatientIcn, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromPatientLastName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromPatientFirstName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromPatientMIddleName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromPatientDob, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientChange.FromPatientDeathDate, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientChange.FromPatientSexCode, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.FromSsnPseudoIndicator, typeof(bool));
			dt.Columns.Add(TABLE.PatientChange.ToPatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientChange.ToPatientSsn, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToPatientIcn, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToPatientLastName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToPatientFirstName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToPatientMIddleName, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToPatientDob, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientChange.ToPatientDeathDate, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientChange.ToPatientSexCode, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.ToSsnPseudoIndicator, typeof(bool));

			// CR 2431	changed to long to allow for the database change of the MergeFromVistaPatientId and MergeToVistaPatientId to Bigint
			dt.Columns.Add(TABLE.PatientChange.MergeFromVistaPatientId, typeof(long));
			dt.Columns.Add(TABLE.PatientChange.MergeToVistaPatientId, typeof(long));
			dt.Columns.Add(TABLE.PatientChange.PatientChangeStatusCode, typeof(string));
			dt.Columns.Add(TABLE.PatientChange.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TABLE.PatientChange.RowVersion, typeof(byte []));

			// The columns will only have values part of the time
			// depending on what sproc loads the table
			dt.Columns.Add(ARTIFICIAL.FromDisplayVistaPatientId, typeof(string));
			dt.Columns.Add(ARTIFICIAL.ToDisplayVistaPatientId, typeof(string));

			// CR 2675
			dt.Columns.Add(TABLE.PatientChange.NotificationReceivedDate, typeof(DateTime));

			// CR 3164
			dt.Columns.Add(TABLE.PatientChange.ActiveDivisionsAlertViewed, typeof(string));
			dt.Columns.Add(ARTIFICIAL.DivisionsWithActiveOrders, typeof(string));
		
			return(dt);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/21/2004</CreationDate>
		/// <summary>
		/// Load the object from the datarow parameter
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientDeathDate))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientDeathDate))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientDeathDate] = dtRow[TABLE.PatientChange.FromPatientDeathDate];
				}
			}		
		
			if (dtRow.Table.Columns.Contains(ARTIFICIAL.FromDisplayVistaPatientId))
			{
				if (!dtRow.IsNull(ARTIFICIAL.FromDisplayVistaPatientId))
				{
					this._drCurrent[ARTIFICIAL.FromDisplayVistaPatientId] = dtRow[ARTIFICIAL.FromDisplayVistaPatientId];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientDob))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientDob))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientDob] = dtRow[TABLE.PatientChange.FromPatientDob];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientFirstName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientFirstName))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientFirstName] = dtRow[TABLE.PatientChange.FromPatientFirstName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientGuid))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientGuid] = dtRow[TABLE.PatientChange.FromPatientGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientIcn))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientIcn))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientIcn] = dtRow[TABLE.PatientChange.FromPatientIcn];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientLastName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientLastName))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientLastName] = dtRow[TABLE.PatientChange.FromPatientLastName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientMIddleName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientMIddleName))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientMIddleName] = dtRow[TABLE.PatientChange.FromPatientMIddleName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientSexCode))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientSexCode))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientSexCode] = dtRow[TABLE.PatientChange.FromPatientSexCode];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientSsn))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromPatientSsn))
				{
					this._drCurrent[TABLE.PatientChange.FromPatientSsn] = dtRow[TABLE.PatientChange.FromPatientSsn];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromSsnPseudoIndicator))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.FromSsnPseudoIndicator))
				{
					this._drCurrent[TABLE.PatientChange.FromSsnPseudoIndicator] = dtRow[TABLE.PatientChange.FromSsnPseudoIndicator];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.MergeFromVistaPatientId))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.MergeFromVistaPatientId))
				{
					this._drCurrent[TABLE.PatientChange.MergeFromVistaPatientId] = dtRow[TABLE.PatientChange.MergeFromVistaPatientId];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.MergeToVistaPatientId))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.MergeToVistaPatientId))
				{
					this._drCurrent[TABLE.PatientChange.MergeToVistaPatientId] = dtRow[TABLE.PatientChange.MergeToVistaPatientId];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.PatientChangeGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.PatientChangeGuid))
				{
					this._drCurrent[TABLE.PatientChange.PatientChangeGuid] = dtRow[TABLE.PatientChange.PatientChangeGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.PatientChangeStatusCode))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.PatientChangeStatusCode))
				{
					this._drCurrent[TABLE.PatientChange.PatientChangeStatusCode] = dtRow[TABLE.PatientChange.PatientChangeStatusCode];
				}
			}	

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientDeathDate))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientDeathDate))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientDeathDate] = dtRow[TABLE.PatientChange.ToPatientDeathDate];
				}
			}		

			if (dtRow.Table.Columns.Contains(ARTIFICIAL.ToDisplayVistaPatientId))
			{
				if (!dtRow.IsNull(ARTIFICIAL.ToDisplayVistaPatientId))
				{
					this._drCurrent[ARTIFICIAL.ToDisplayVistaPatientId] = dtRow[ARTIFICIAL.ToDisplayVistaPatientId];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientDob))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientDob))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientDob] = dtRow[TABLE.PatientChange.ToPatientDob];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientFirstName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientFirstName))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientFirstName] = dtRow[TABLE.PatientChange.ToPatientFirstName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientGuid))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientGuid] = dtRow[TABLE.PatientChange.ToPatientGuid];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientIcn))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientIcn))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientIcn] = dtRow[TABLE.PatientChange.ToPatientIcn];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientLastName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientLastName))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientLastName] = dtRow[TABLE.PatientChange.ToPatientLastName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientMIddleName))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientMIddleName))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientMIddleName] = dtRow[TABLE.PatientChange.ToPatientMIddleName];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientSexCode))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientSexCode))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientSexCode] = dtRow[TABLE.PatientChange.ToPatientSexCode];
				}
			}		

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientSsn))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToPatientSsn))
				{
					this._drCurrent[TABLE.PatientChange.ToPatientSsn] = dtRow[TABLE.PatientChange.ToPatientSsn];
				}
			}	
	
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToSsnPseudoIndicator))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ToSsnPseudoIndicator))
				{
					this._drCurrent[TABLE.PatientChange.ToSsnPseudoIndicator] = dtRow[TABLE.PatientChange.ToSsnPseudoIndicator];
				}
			}	
	
			// CR 2675
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.NotificationReceivedDate))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.NotificationReceivedDate))
				{
					this.NotificationReceivedDate = 
						(DateTime)dtRow[TABLE.PatientChange.NotificationReceivedDate];
				}
			}

			// CR 3164
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ActiveDivisionsAlertViewed))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.ActiveDivisionsAlertViewed))
				{
					this.ActiveDivisionsAlertViewed = dtRow[TABLE.PatientChange.ActiveDivisionsAlertViewed].ToString();
				}
			}

			// CR 3164
			if (dtRow.Table.Columns.Contains(ARTIFICIAL.DivisionsWithActiveOrders))
			{
				if (!dtRow.IsNull(ARTIFICIAL.DivisionsWithActiveOrders))
				{
					this.DivisionsWithActiveOrders = dtRow[ARTIFICIAL.DivisionsWithActiveOrders].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.LastUpdateDate))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.LastUpdateDate))
				{
					this.LastUpdateDate = (DateTime)dtRow[TABLE.PatientChange.LastUpdateDate];
				}
			}			

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.RowVersion))
				{
					this.RowVersion = (byte [])dtRow[TABLE.PatientChange.RowVersion];
				}
			}

			this.IsNew = false;
			this.IsDirty = true;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3297"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3299"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Loads and returns a datarow with the object data
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientDeathDate))
			{
				dtRow[TABLE.PatientChange.FromPatientDeathDate] = this.FromPatientDeathDate;
			}
	
			if (dtRow.Table.Columns.Contains(ARTIFICIAL.FromDisplayVistaPatientId))
			{
				dtRow[ARTIFICIAL.FromDisplayVistaPatientId] = this.FromPatientDisplayVistaPatientId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientDob))
			{
				dtRow[TABLE.PatientChange.FromPatientDob] = this.FromPatientDob;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientFirstName))
			{
				dtRow[TABLE.PatientChange.FromPatientFirstName] = this.FromPatientFirstName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientGuid))
			{
				dtRow[TABLE.PatientChange.FromPatientGuid] = this.FromPatientGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientIcn))
			{
				dtRow[TABLE.PatientChange.FromPatientIcn] = this.FromPatientIcn;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientLastName))
			{
				dtRow[TABLE.PatientChange.FromPatientLastName] = this.FromPatientLastName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientMIddleName))
			{
				dtRow[TABLE.PatientChange.FromPatientMIddleName] = this.FromPatientMiddleName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.FromPatientSexCode))
			{
				dtRow[TABLE.PatientChange.FromPatientSexCode] = this.FromPatientSexCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.MergeFromVistaPatientId))
			{
				dtRow[TABLE.PatientChange.MergeFromVistaPatientId] = this.MergeFromVistaPatientId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.MergeToVistaPatientId))
			{
				dtRow[TABLE.PatientChange.MergeToVistaPatientId] = this.MergeToVistaPatientId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.PatientChangeGuid))
			{
				dtRow[TABLE.PatientChange.PatientChangeGuid] = this.PatientChangeGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.PatientChangeStatusCode))
			{
				dtRow[TABLE.PatientChange.PatientChangeStatusCode] = this.PatientChangeStatusCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientDeathDate))
			{
				dtRow[TABLE.PatientChange.ToPatientDeathDate] = this.ToPatientDeathDate;
			}

			if (dtRow.Table.Columns.Contains(ARTIFICIAL.ToDisplayVistaPatientId))
			{
				dtRow[ARTIFICIAL.ToDisplayVistaPatientId] = this.ToPatientDisplayVistaPatientId;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientDob))
			{
				dtRow[TABLE.PatientChange.ToPatientDob] = this.ToPatientDob;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientFirstName))
			{
				dtRow[TABLE.PatientChange.ToPatientFirstName] = this.ToPatientFirstName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientGuid))
			{
				dtRow[TABLE.PatientChange.ToPatientGuid] = this.ToPatientGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientIcn))
			{
				dtRow[TABLE.PatientChange.ToPatientIcn] = this.ToPatientIcn;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientLastName))
			{
				dtRow[TABLE.PatientChange.ToPatientLastName] = this.ToPatientLastName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientMIddleName))
			{
				dtRow[TABLE.PatientChange.ToPatientMIddleName] = this.ToPatientMiddleName;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ToPatientSexCode))
			{
				dtRow[TABLE.PatientChange.ToPatientSexCode] = this.ToPatientSexCode;
			}

			// CR 2675
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.NotificationReceivedDate))
			{
				dtRow[TABLE.PatientChange.NotificationReceivedDate] = this.NotificationReceivedDate;
			}

			// CR 3164
			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.ActiveDivisionsAlertViewed))
			{
				dtRow[TABLE.PatientChange.ActiveDivisionsAlertViewed] = this.ActiveDivisionsAlertViewed;
			}

			// CR 3164
			if (dtRow.Table.Columns.Contains(ARTIFICIAL.DivisionsWithActiveOrders))
			{
				dtRow[ARTIFICIAL.DivisionsWithActiveOrders] = this.DivisionsWithActiveOrders;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientChange.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientChange.RowVersion))
				{
					dtRow[TABLE.PatientChange.RowVersion] = this.RowVersion;
				}
				else
				{
					dtRow[TABLE.PatientChange.RowVersion] = DBNull.Value;
				}
			}

			return(dtRow);
		}

		#endregion

		#region Static Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/24/2006</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4311"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>arraylist</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4312"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Implements BR_84.07 : The system notifies users of patient merges 
		/// only if one or both of the merged patients are known to VBECS.
		/// </summary>
		/// <returns>DataTable</returns>
		public static int GetPendingPatientMergesCount()
		{	
			DataTable pendingMergesTable = DAL.Patient.GetPendingPatientMerges(Common.LogonUser.LogonUserDivisionCode);
			//
			if(pendingMergesTable != null && pendingMergesTable.Rows != null)
			{
				return Convert.ToInt32( pendingMergesTable.Rows[0][ARTIFICIAL.PendingPatientMergesCount] );
			}
			//
			return 0;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/2/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4943"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Arraylist</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4944"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetPendingPatientMergesDetails
		/// </summary>
		/// <returns>PatientChange []</returns>
		public static PatientChange [] GetPendingPatientMergesDetails()
		{	
			DataTable mergeTable = DAL.Patient.GetPendingPatientMergesDetails(Common.LogonUser.LogonUserDivisionCode);
			//
			return GetPatientChangeArrayFromTable(mergeTable);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/4/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4309"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4310"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Implements BR_84.06 : The system notifies users of patient updates or 
		/// of the patients death only if the patient has current or pending 
		/// orders in the actors division.
		/// </summary>
		/// <returns>int</returns>
		public static int GetRecentlyDeceasedPatientsCount()
		{
			// CR 3164: added bool parameter for changed GetValidatedPatientUpdates signature
			DataTable validatedPatientTable = GetValidatedPatientUpdates(
				DAL.Patient.GetRecentlyDeceasedPatients(Common.LogonUser.LogonUserDivisionCode), false);
			//
			if(validatedPatientTable != null && validatedPatientTable.Rows != null)
			{
				return validatedPatientTable.Rows.Count;
			}
			//
			return 0;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/2/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4939"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Arraylist</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4940"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetRecentlyDeceasedPatientsDetails
		/// </summary>
		/// <returns>PatientChange []</returns>
		public static PatientChange [] GetRecentlyDeceasedPatientsDetails()
		{	
			// CR 3164: added bool parameter for changed GetValidatedPatientUpdates signature
			DataTable deceasedPatientTable = GetValidatedPatientUpdates(
				DAL.Patient.GetRecentlyDeceasedPatientDetails(Common.LogonUser.LogonUserDivisionCode), true);
			//
			return GetPatientChangeArrayFromTable(deceasedPatientTable);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/24/2006</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4307"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4308"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Implements BR_84.06 : The system notifies users of patient updates or 
		/// of the patients death only if the patient has current or pending 
		/// orders in the actors division.
		/// </summary>
		/// <returns>int</returns>
		public static int GetRecentlyUpdatedPatientCount()
		{
			// CR 3164: added bool parameter for changed GetValidatedPatientUpdates signature
			DataTable validatedPatientTable = GetValidatedPatientUpdates(
				DAL.Patient.GetRecentlyUpdatedPatients(Common.LogonUser.LogonUserDivisionCode), false);
			//
			if(validatedPatientTable != null && validatedPatientTable.Rows != null)
			{
				return validatedPatientTable.Rows.Count;
			}
			//
			return 0;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/2/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="4941"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Arraylist</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4942"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="8491"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>PatientChange ArrayList</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetRecentlyUpdatedPatientDetails
		/// </summary>
		/// <returns>PatientChange []</returns>
		public static PatientChange [] GetRecentlyUpdatedPatientDetails()
		{	
			// CR 3164: added bool parameter for changed GetValidatedPatientUpdates signature
			DataTable updatedPatientTable = GetValidatedPatientUpdates(
				DAL.Patient.GetRecentlyUpdatedPatientDetails(Common.LogonUser.LogonUserDivisionCode), true);
			//
			return GetPatientChangeArrayFromTable(updatedPatientTable);
		}

		///<Developers>
		///	<Developer>Hines OIFO</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/5/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9235"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9236"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// CR 3164: adds divisionCodeToAdd to activeDivisionsAlertViewedList and returns string
		/// of divisions separated by PatientChange.DivisionDelimiter
		/// </summary>
		/// <param name="divisionCodeToAdd"></param>
		/// <param name="activeDivisionsAlertViewedList"></param>
		/// <returns></returns>
		public static string BuildAlertViewedString( string divisionCodeToAdd, ArrayList activeDivisionsAlertViewedList )
		{
			string activeDivisions = string.Empty;
			if ( activeDivisionsAlertViewedList != null && activeDivisionsAlertViewedList.Count > 0 )
			{
				for (int idx = 0; idx < activeDivisionsAlertViewedList.Count; idx++ )
				{
					if ( activeDivisions.Length > 0 ) { activeDivisions += PatientChange.DivisionDelimiter; }
					activeDivisions += activeDivisionsAlertViewedList[idx];
				}
				if ( !activeDivisionsAlertViewedList.Contains(divisionCodeToAdd) )
				{
					if ( activeDivisions.Length > 0 ) { activeDivisions += PatientChange.DivisionDelimiter; }
					activeDivisions += divisionCodeToAdd;
				}
			}
			else
			{
				activeDivisions = divisionCodeToAdd;
			}
			return activeDivisions;
		}

		/// <summary>
		/// This method serves dual purposes: 
		/// (1) Checks whether an alert should be displayed for a active update record.  If the update record has an active order in  
		/// the current division and the ActiveDivisionsAlertViewed field does not yet contain the current division code, then we know  
		/// the update has not been viewed.  Only update records that are in a status of Pending are checked for alert purposes.  
		/// (2) Checks whether an update record should be marked inactive.  If the record does not have an active order in any division
		/// then we mark the update record inactive.
		/// Implements BR_68.02, BR_68.14
		/// CR 3164: completely revised to support division specific viewing and clearing of updates
		/// </summary>
		/// <param name="updatedPatientTable"></param>
		/// <param name="detailsRequested"></param>
		/// <returns>DataTable</returns>
		private static DataTable GetValidatedPatientUpdates(DataTable updatedPatientTable, bool detailsRequested)
		{	
			DataTable validatedPatientTable = updatedPatientTable.Clone();
			//	
			if ( updatedPatientTable != null && updatedPatientTable.Rows.Count > 0 )
			{
				for ( int i = 0; i < updatedPatientTable.Rows.Count; i++ )
				{
					bool updateViewed = false;
					string currentDivision = Common.LogonUser.LogonUserDivisionCode.TrimEnd();
					//
					// This string contains the list of divisions in which this patient has active order(s)
					string divisionsWithActiveOrders = updatedPatientTable.Rows[i][ARTIFICIAL.DivisionsWithActiveOrders].ToString();
					ArrayList divisionsWithActiveOrdersList = null;
					if ( divisionsWithActiveOrders != null && divisionsWithActiveOrders.Length > 0 ) 
					{ 
						divisionsWithActiveOrdersList = new ArrayList( divisionsWithActiveOrders.Split(PatientChange.DivisionDelimiterSplitter) ); 
					}
					// This string contains the list of divisions in which this patient has viewed the update(s)
					string activeDivisionsAlertViewed = updatedPatientTable.Rows[i][TABLE.PatientChange.ActiveDivisionsAlertViewed].ToString();
					ArrayList activeDivisionsAlertViewedList = null;
					if ( activeDivisionsAlertViewed != null && activeDivisionsAlertViewed.Length > 0 ) 
					{ 
						activeDivisionsAlertViewedList = new ArrayList( activeDivisionsAlertViewed.Split(PatientChange.DivisionDelimiterSplitter) ); 
					}
					//
					bool currentDivisionHasActiveOrders = divisionsWithActiveOrdersList != null && divisionsWithActiveOrdersList.Contains(currentDivision);
					if ( currentDivisionHasActiveOrders )
					{
						if ( activeDivisionsAlertViewedList != null && activeDivisionsAlertViewedList.Contains(currentDivision) )
						{
							updateViewed = true;
						}
					}
					//
					if( (currentDivisionHasActiveOrders && !updateViewed) || (detailsRequested && divisionsWithActiveOrdersList != null) )
					{
						validatedPatientTable.ImportRow(updatedPatientTable.Rows[i]);
					}
					//
					if ( divisionsWithActiveOrdersList == null )
					{
						// Mark the patient update record as inactive since there are no active orders for this update
						try
						{
							DAL.Patient.UpdatePatientChangeStatus(
								(Guid)updatedPatientTable.Rows[i][TABLE.PatientChange.PatientChangeGuid], Common.PatientChangeStatus.Inactive, null, 
								(byte [])updatedPatientTable.Rows[i][TABLE.PatientChange.RowVersion], Common.UpdateFunction.UC0108_UpdatedPatients );
						}
						catch( Common.DataAccessLayerException )
						{
							// Suppress row-version exception (extremely unlikely)
						}
					}
				} // end: for ( int i = 0; i < updatedPatientTable.Rows.Count; i++ )
			} // end: if ( updatedPatientTable != null && updatedPatientTable.Rows.Count > 0 )
			//
			return validatedPatientTable;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="patientChangeTable"></param>
		/// <returns></returns>
		private static PatientChange [] GetPatientChangeArrayFromTable(DataTable patientChangeTable)
		{	
			PatientChange [] patientChanges = null;
			//
			int rowCount = patientChangeTable.Rows.Count;
			//
			if (rowCount > 0)
			{
				patientChanges = new PatientChange [rowCount];
				//
				for (int idx = 0; idx < rowCount; idx++)
				{
					patientChanges[idx] = new PatientChange(patientChangeTable.Rows[idx]);
				}
			}
			//
			return patientChanges;
		}

		#endregion

		#endregion
	}
}
